//Note: Details of scilab software version and OS version used:
//OS: Windows 7
//Scilab version: 5.4.1
//IPD Atom version:8.3.1-2
//SIVP Atom version:0.5.3.1-2
clc;
clear all;
close;
s=poly(0,'s');
//The parameters 1.Angular Position 2. Angular Velocity of DC Motors
//are obtained from MATLAB demos file.
Angular_Position =(0.003127*s+0.9815)/(s^2+3.929*s+6.343e-05);
Angular_velocity = (1.04*s+0.2756)/(s^2+4.461*s+1.096);
model = [Angular_Position,Angular_velocity];
H1 = model(:,1); //Angular Position
H2 = model(:,2); //Angular velocity
np=20; //number of points
t = 0:0.02:20;
ysd1 = csim('impulse',t,model(:,1));
ysd2 = csim('impulse',t,model(:,2));
subplot(2,1,1)
plot(t,ysd1,'.-b')
title('Impulse Response - Angular Position')
xgrid(1)
subplot(2,1,2)
plot(t,ysd2,'.-r')
title('Impulse response-Angular velocity')
xgrid(1)
disp(model,'Model System Equations =')
disp(ysd1,'Impulse Resposne of Angular Position =')
disp(ysd2,'Impulse Response of Angular velocity=')

//RESULT
//Model System Equations =   
// 
//      0.9815 + 0.003127s         0.2756 + 1.04s     
//    ----------------------     ------------------   
//                          2                      2  
//    0.0000634 + 3.929s + s     1.096 + 4.461s + s   
 
